/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.foundation.blockEntity;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.gui.ScreenOpener;
import com.zurrtum.create.client.foundation.blockEntity.ValueSettingsScreen;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueSettingsInputHandler;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.infrastructure.packet.c2s.ValueSettingsPacket;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_746;

@Environment(value=EnvType.CLIENT)
public class ValueSettingsClient {
    public int interactHeldTicks = -1;
    public class_2338 interactHeldPos = null;
    public BehaviourType<? extends BlockEntityBehaviour<?>> interactHeldBehaviour = null;
    public class_1268 interactHeldHand = null;
    public class_2350 interactHeldFace = null;
    public List<class_5250> lastHoverTip;
    public int hoverTicks;
    public int hoverWarmup;

    public boolean cancelIfWarmupAlreadyStarted(class_2338 pos) {
        return this.interactHeldTicks != -1 && pos.equals((Object)this.interactHeldPos);
    }

    public void startInteractionWith(class_2338 pos, BehaviourType<? extends BlockEntityBehaviour<?>> behaviourType, class_1268 hand, class_2350 side) {
        this.interactHeldTicks = 0;
        this.interactHeldPos = pos;
        this.interactHeldBehaviour = behaviourType;
        this.interactHeldHand = hand;
        this.interactHeldFace = side;
    }

    public void cancelInteraction() {
        this.interactHeldTicks = -1;
    }

    public void tick(class_310 mc) {
        ValueSettingsBehaviour valueSettingBehaviour;
        class_3965 blockHitResult;
        if (this.hoverWarmup > 0) {
            --this.hoverWarmup;
        }
        if (this.hoverTicks > 0) {
            --this.hoverTicks;
        }
        if (this.interactHeldTicks == -1) {
            return;
        }
        class_746 player = mc.field_1724;
        if (!ValueSettingsInputHandler.canInteract((class_1657)player) || player.method_6047().method_31574((class_1792)AllItems.CLIPBOARD)) {
            this.cancelInteraction();
            return;
        }
        class_239 hitResult = mc.field_1765;
        if (!(hitResult instanceof class_3965) || !(blockHitResult = (class_3965)hitResult).method_17777().equals((Object)this.interactHeldPos)) {
            this.cancelInteraction();
            return;
        }
        BlockEntityBehaviour<?> behaviour = BlockEntityBehaviour.get((class_1922)mc.field_1687, this.interactHeldPos, this.interactHeldBehaviour);
        if (!(behaviour instanceof ValueSettingsBehaviour) || (valueSettingBehaviour = (ValueSettingsBehaviour)((Object)behaviour)).bypassesInput(player.method_6047()) || !valueSettingBehaviour.testHit(blockHitResult.method_17784())) {
            this.cancelInteraction();
            return;
        }
        if (!mc.field_1690.field_1904.method_1434()) {
            player.field_3944.method_52787((class_2596)new ValueSettingsPacket(this.interactHeldPos, 0, 0, this.interactHeldHand, blockHitResult, this.interactHeldFace, false, valueSettingBehaviour.netId()));
            valueSettingBehaviour.onShortInteract((class_1657)player, this.interactHeldHand, this.interactHeldFace, blockHitResult);
            this.cancelInteraction();
            return;
        }
        if (this.interactHeldTicks > 3) {
            player.field_6252 = false;
        }
        if (this.interactHeldTicks++ < 5) {
            return;
        }
        ScreenOpener.open(new ValueSettingsScreen(this.interactHeldPos, valueSettingBehaviour.createBoard((class_1657)player, blockHitResult), valueSettingBehaviour.getValueSettings(), valueSettingBehaviour::newSettingHovered, valueSettingBehaviour.netId()));
        this.interactHeldTicks = -1;
    }

    public void showHoverTip(class_310 mc, List<class_5250> tip) {
        if (mc.field_1755 != null) {
            return;
        }
        if (this.hoverWarmup < 6) {
            this.hoverWarmup += 2;
            return;
        }
        ++this.hoverWarmup;
        this.hoverTicks = this.hoverTicks == 0 ? 11 : Math.max(this.hoverTicks, 6);
        this.lastHoverTip = tip;
    }

    public void render(class_310 mc, class_332 guiGraphics) {
        if (!ValueSettingsInputHandler.canInteract((class_1657)mc.field_1724)) {
            return;
        }
        if (this.hoverTicks == 0 || this.lastHoverTip == null) {
            return;
        }
        int x = guiGraphics.method_51421() / 2;
        int y = guiGraphics.method_51443() - 75 - this.lastHoverTip.size() * 12;
        float alpha = this.hoverTicks > 5 ? (float)(11 - this.hoverTicks) / 5.0f : Math.min(1.0f, (float)this.hoverTicks / 5.0f);
        Color color = new Color(0xFFFFFF);
        Color titleColor = new Color(16505981);
        color.setAlpha(alpha);
        titleColor.setAlpha(alpha);
        for (int i = 0; i < this.lastHoverTip.size(); ++i) {
            class_5250 mutableComponent = this.lastHoverTip.get(i);
            guiGraphics.method_51439(mc.field_1772, (class_2561)mutableComponent, x - mc.field_1772.method_27525((class_5348)mutableComponent) / 2, y, (i == 0 ? titleColor : color).getRGB(), true);
            y += 12;
        }
    }
}

